<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;
    protected $fillable = array('message', 'client_id', 'driver_id', 'conversation_id', 'is_read');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function driver()
    {
        return $this->belongsTo('App\Models\Driver');
    }

}